/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.tools.bleeder;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class LegeditBleeder
extends JFrame {
    static String filePath = "";
    static double scale = 2.0;
    static double xPadding = 0.043;
    static double yPadding = 0.08;
    static String exportType = "jpg";
    static Color backColor = Color.BLACK;
    static boolean fancyBleed = false;
    static float compressionQuality = 0.0f;

    public LegeditBleeder() {
        String str;
        this.setDefaultCloseOperation(2);
        this.setTitle("Bleeder");
        this.add(new JLabel("Working..."));
        this.setVisible(true);
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        int outcome = chooser.showOpenDialog(this);
        if (outcome != 0) {
            JOptionPane.showMessageDialog(this, "No File Selected");
            return;
        }
        filePath = chooser.getSelectedFile().getAbsolutePath();
        try {
            String str2 = JOptionPane.showInputDialog("Enter the scale (original size X this value)", (Object)("" + scale));
            scale = Double.parseDouble(str2);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            return;
        }
        JColorChooser color = new JColorChooser(backColor);
        Color c = JColorChooser.showDialog(this, "Select a backing color", backColor);
        backColor = c != null ? c : Color.GRAY;
        try {
            str = JOptionPane.showInputDialog("Enter the horizontal padding (% to expand horizontal bleed)", (Object)("" + xPadding));
            xPadding = Double.parseDouble(str);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            return;
        }
        try {
            str = JOptionPane.showInputDialog("Enter the vertical padding (% to expand vertical bleed)", (Object)("" + yPadding));
            yPadding = Double.parseDouble(str);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            return;
        }
        outcome = JOptionPane.showOptionDialog(this, "Do Fancy Bleed? This will take longer.", "Fancy Bleed?", 0, 3, null, null, null);
        fancyBleed = outcome == 0;
        this.doResize();
        JOptionPane.showMessageDialog(this, "Done!");
    }

    public void doResize() {
        File folder = new File(filePath);
        if (folder.exists() && folder.isDirectory()) {
            File[] files;
            File[] fileArray = files = folder.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                System.out.println(f.getAbsolutePath());
                ImageIcon imageIcon = null;
                String imageType = null;
                if (f.getAbsolutePath().toLowerCase().endsWith("jpg") || f.getAbsolutePath().toLowerCase().endsWith("jpeg")) {
                    try {
                        imageIcon = new ImageIcon(f.getAbsolutePath());
                        imageType = "jpg";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (f.getAbsolutePath().toLowerCase().endsWith("png")) {
                    try {
                        imageIcon = new ImageIcon(f.getAbsolutePath());
                        imageType = "png";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (imageIcon != null && imageType != null) {
                    try {
                        File dir = new File(folder.getAbsoluteFile() + File.separator + "resized" + File.separator);
                        dir.mkdirs();
                        File newFile = new File(folder.getAbsoluteFile() + File.separator + "resized" + File.separator + f.getName().replace(".png", "").replace(".jpg", "").replace(".jpeg", "") + "." + exportType);
                        BufferedImage bi = LegeditBleeder.resizeImage(imageIcon, scale);
                        if (exportType.equals("jpg")) {
                            try {
                                BufferedImage rendImage = bi;
                                ImageWriter writer = null;
                                Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
                                if (iter.hasNext()) {
                                    writer = iter.next();
                                }
                                newFile.createNewFile();
                                ImageOutputStream ios = ImageIO.createImageOutputStream(newFile);
                                writer.setOutput(ios);
                                MyImageWriteParam iwparam = new MyImageWriteParam();
                                iwparam.setCompressionMode(2);
                                ((ImageWriteParam)iwparam).setCompressionQuality(compressionQuality);
                                writer.write(null, new IIOImage(rendImage, null, null), iwparam);
                                ios.flush();
                                writer.dispose();
                                ios.close();
                            }
                            catch (IOException iOException) {}
                        } else {
                            ImageIO.write((RenderedImage)bi, exportType, newFile);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
    }

    public static BufferedImage resizeImage(ImageIcon imageIcon, double scale) {
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int xPad = (int)((double)imageIcon.getIconWidth() * scale * xPadding);
        int fullW = w + xPad + xPad;
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int yPad = (int)((double)imageIcon.getIconHeight() * scale * yPadding);
        int fullH = h + yPad + yPad;
        int type = 2;
        if (exportType.equals("jpg")) {
            type = 1;
        }
        BufferedImage image = new BufferedImage(fullW, fullH, type);
        Graphics g = image.getGraphics();
        g.setColor(backColor);
        g.fillRect(0, 0, fullW, fullH);
        if (fancyBleed) {
            int padSize = xPad;
            if (yPad > xPad) {
                padSize = yPad;
            }
            int increment = padSize;
            int i = padSize;
            while (i > 0) {
                g.drawImage(imageIcon.getImage(), xPad - increment, yPad - increment, w + xPad + increment, h + yPad + increment, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
                --increment;
                --i;
            }
        }
        g.drawImage(imageIcon.getImage(), xPad, yPad, w + xPad, h + yPad, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    private static class MyImageWriteParam
    extends JPEGImageWriteParam {
        public MyImageWriteParam() {
            super(Locale.getDefault());
        }

        @Override
        public void setCompressionQuality(float quality) {
            if (quality < 0.0f || quality > 1.0f) {
                throw new IllegalArgumentException("Quality out-of-bounds!");
            }
            this.compressionQuality = 256.0f - quality * 256.0f;
        }
    }
}

